<?php

/* Déroulement de l'évaluation : Vous allez devoir réaliser un passage de fichiers JSON en CSV Ã  l'aide d'un programme rÃ©alisÃ© avec le langage PHP.
Lâ€™objectif Ã©tant dâ€™approfondir vos connaissances ainsi que vos compÃ©tences en PHP mais Ã©galement au niveau de la manipulation des donnÃ©es au sein dâ€™un fichier JSON/CSV. 
ComplÃ©ter le programme suivant (en vous aidant de la documentation PHP) en respectant la structure du CSV : 
Code Insee / Code postal / Commune / Nombre habitants / Rue / Ordures / Recurrence / Tri / Recurrence 
Vous devez remplacer tous les "..." */

// Emplacement du fichier
$file = "json_clermont.json";

// Lecture entière du fichier
$content = file_get_contents($file);

// Ouverture du fichier 
$file2 = fopen($content);

// Décodage de la chaîne JSON
$datasets = json_decode($content, true);

// Formatage de plusieurs ligne en CSV et écriture dans le fichier
fputcsv($file2, 
    [
    'Code Insee',
    'Code postal',
    'Commune',
    'Nombre habitants',
    'Rue',
    'Ordures',
    'Recurrence',
    'Tri',
    'Recurrence',
    ]);


foreach ($datasets as $dataset) 
    {
    /* BONUS : SÃ©parez les jours et horaires des ordures mÃ©nagÃ¨res et du tri sÃ©lectif en deux colonnes dans le fichier CSV.
    De ce fait, la structure du CSV devra donc Ãªtre : 
    Code Insee / Code postal / Commune / Nombre habitants / Rue / Ordures / Horaires ordures / Recurrence / Tri / Horaires tri / Recurrence

    Aide : Utilisation de la fonction explode permet de scinder une chaÃ®ne de caractÃ¨res en segments
    explode(...);

    Utilisation de la fonction preg_match_all (expression rationnelle globale) 
    et des expressions rÃ©guliÃ¨res (chaÃ®nes de caractÃ¨res, qui dÃ©crivent, selon une syntaxe prÃ©cise, 
    un ensemble de chaÃ®nes de caractÃ¨res possibles)
    preg_match_all(...); */

    fputcsv($file2, 
		[
		substr('63113', 1),
		substr('63110', 1),
		$dataset['nom'],
		substr('145041', 1),
		$dataset['voie'],
		implode(' - ', $dataset[''] ?? []),
		implode(' - ', $dataset[''] ?? []),
		substr(' ... ', 1),
		$dataset['dechets_recyclables_jours'],
		$dataset['nom'],
		substr(' ... ', 1),
		]);
    }
?>